local t = Def.ActorFrame{};

local function moveMusicWheel(event)
	local pn = event.PlayerNumber
	if event.type == "InputEventType_Release" then return false end
	
	if pn then
		if event.GameButton == "MenuUp" then
			local topScreen = SCREENMAN:GetTopScreen();
			local screenName = topScreen:GetName();
			if screenName == "ScreenSelectMusic" then
				local MusicWheel = topScreen:GetChild("MusicWheel");
				if MusicWheel ~= nil then
					MusicWheel:Move(-1)
					MusicWheel:Move(0)
				end;
			end;
		end
		if event.GameButton == "MenuDown" then
			local topScreen = SCREENMAN:GetTopScreen();
			local screenName = topScreen:GetName();
			if screenName == "ScreenSelectMusic" then
				local MusicWheel = topScreen:GetChild("MusicWheel");
				if MusicWheel ~= nil then
					MusicWheel:Move(1)
					MusicWheel:Move(0)
				end;
			end;
		end
	end
end

for PN in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		Def.Quad{
			InitCommand=cmd(y,Top()+110;visible,false;zoomto,286,326);
			OnCommand=function(self)
				if PN == PLAYER_1 then self:x(Left()):align(0,0) else self:x(Right()):align(1,0) end
				self:diffuse(color(LoadFile("ThemeColor.cfg","Settings")))
			end;
			ThemeColorChangedMessageCommand=cmd(playcommand,"On");
			OptionsListOpenedMessageCommand=function(self,params,pn)
				if params.Player == PN then
					self:visible(true)
					SCREENMAN:GetTopScreen():AddInputCallback(moveMusicWheel)
				end
			end;
			OptionsListClosedMessageCommand=function(self,params,pn)
				if params.Player == PN then
					self:visible(false)
					SCREENMAN:GetTopScreen():RemoveInputCallback(moveMusicWheel)
				end
			end;
		};
		Def.Quad{
			InitCommand=cmd(y,Top()+118;visible,false;zoomto,270,310);
			OnCommand=function(self)
				if PN == PLAYER_1 then self:x(Left()+8):align(0,0) else self:x(Right()-8):align(1,0) end
				self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2))	
			end;
			ThemeColorChangedMessageCommand=cmd(playcommand,"On");
			OptionsListOpenedMessageCommand=function(self,params,pn)
				if params.Player == PN then
					self:visible(true)
				end
			end;
			OptionsListClosedMessageCommand=function(self,params,pn)
				if params.Player == PN then
					self:visible(false)
				end
			end;
		};
		EasterEgg(10,"Open the Options List for the first time.")..{InitCommand=cmd(visible,false);
			OptionsListOpenedMessageCommand=function(self,params,pn)
				if params.Player == PN and LoadFile("10.cfg","Unlocks/Easter Eggs") == "????" then
					self:visible(true):playcommand("Show")
					WriteFile("10.cfg","EASTER EGG #10 FOUND!\nOpen the Options List for the first time.","Unlocks/Easter Eggs")
				end
			end;
			ShowCommand=cmd(diffusealpha,0;sleep,0.25;smooth,0.5;diffusealpha,1;sleep,5;linear,0.5;diffusealpha,0);
		};
		LoadActor(THEME:GetPathS("","_Achievement"))..{
			OptionsListOpenedMessageCommand=function(self,params,pn)
				if params.Player == PN and LoadFile("10.cfg","Unlocks/Easter Eggs") == "????" then
					self:playcommand("Show")
				end
			end;
			ShowCommand=cmd(play);
		};
	};
end
	
return t